from hex import Hex

class Map(object):
    
    def __init__(self, asci_map):
        object.__init__(self)
        xsize = len(asci_map[0])
        ysize = len(asci_map)
        
        self.size = ( xsize, ysize )

        # initialize the array of hexes
        self.hexes = hexes = [ None ] * ysize
        for yindex in range (ysize):
            hexes[yindex] = [ None ] * xsize
            for xindex in range(xsize):
                hexes[yindex][xindex]=Hex(asci_map[yindex][xindex])

    def getHex(self, x, y):
        return self.hexes[y][x]

    def getSize(self):
        return self.size

    def __getNeighbors__(self, hexx, hexy):
        if hexy % 2 == 0:
            return [(hexx,hexy-1,1),(hexx+1,hexy,2),(hexx,hexy+1,4),
                (hexx-1,hexy+1,8),(hexx-1,hexy,16),(hexx-1,hexy-1,32)]
        else:
            return [(hexx+1,hexy-1,1),(hexx+1,hexy,2),(hexx+1,hexy+1,4),
                (hexx,hexy+1,8),(hexx-1,hexy,16),(hexx,hexy-1,32)]

    def getNeighbors(self, hexx, hexy):
        """Returns valid neighbors as a list of (x, y, bit) tuples.
        The bit value starts at up-right, going clockwise."""
        neighbors = self.__getNeighbors__(hexx, hexy)
        size = self.size
        return [(hx,hy,bit) for (hx,hy,bit) in neighbors 
            if not (hx >= size[0] or hy >= size[1] or hx < 0 or hy < 0)]



