#!/usr/bin/env python

import sys
from random import randint
from pathfinder import Pathfinder

# map display formatting functions
red = "\033[0;31m"
green = "\033[1;32m"
dgreen = "\033[0;32m"
yellow = "\033[1;33m"
dyellow = "\033[0;33m"
magenta = "\033[0;35m"
blue = "\033[0;34m"
normal = "\033[0m"
def hl(xy): return "%s%s%s" % (magenta,xy,normal)
def sprint(text): sys.stdout.write(text)

#
### methods to display map and path
#
class DbgPath(Pathfinder):

    def __init__(self,*args):
        self.tc_map = []
        return Pathfinder.__init__(self,*args)

    def show_path(self,test_prob):
        self.path,self.skip_nodes = \
                self.calculatePath(_test=1,*test_prob)
        self.show_map()
        
    def show_map(self):
        self.map_key()
        xsize = self.map.size[0]
        for x in range(xsize):
            sprint(" / \\")
        print
        self.show_rows()
        print "Path Length: %s" % len(self.path)

    def show_rows(self,y=0,odd=0,me=None):
        xsize, ysize = self.map.getSize()
        if ysize == y: return y
        if odd: 
            print "  ",
        sprint("|");
        for x in range(xsize):
            # on small maps show coords
            if xsize > 10 or ysize > 10:
                self.big_coord_print(x,y)
            else:
                self.coord_print(x,y)
        print
        if odd: 
            print " /",
        for x in range(xsize):
            sprint(" \ /")
        if odd: 
            odd = 0
        else:
            sprint(" \\")
            odd=1
        print
        if not me:
            me = self.show_rows
        return me(y+1,odd,me)

    def coord_print(self,x,y):
        t_cost = self.tc_map[y][x]
        if t_cost > 0.9: thl = green
        elif t_cost > .7: thl = dgreen
        elif t_cost > .5: thl = yellow
        elif t_cost > .3: thl = dyellow
        elif t_cost < 0.2: thl = blue
        else: thl = red
        if (x,y) in self.path: 
            sprint("%s%s,%s%s|" % (hl(x),thl,normal,hl(y)))
        else:
            sprint("%s%s,%s%s|" % (thl,x,y,normal))

    def big_coord_print(self,x,y):
        t_cost = self.tc_map[x][y]
        if t_cost > 0.9: thl = green
        elif t_cost > .7: thl = dgreen
        elif t_cost > .5: thl = yellow
        elif t_cost > .3: thl = dyellow
        elif t_cost < 0.1: thl = blue
        else: thl = red
        if (x,y) in self.path: 
            sprint("%s|%s%s%s|%s|" % (thl,normal,hl('*'),thl,normal))
        elif self.skip_nodes.has_key((x,y)): 
            sprint("%s|#|%s|" % (thl,normal))
        else:
            sprint(" %s#%s |" % (thl,normal))

    def map_key(self):
        print "------------------------------------------------------"
        print " Terrain costs range from 0-1 with 0 being impassable"
        print " %s1-.9%s  " % (green,normal),
        print "%s.9-.7%s  " % (dgreen,normal),
        print "%s.7-.5%s  " % (yellow,normal),
        print "%s.5-.3%s  " % (dyellow,normal),
        print "%s.1-.2%s  " % (blue,normal),
        print "%s0-.1%s" % (red,normal)
        print " magenta asterisks %s mark the path" % hl('*')
        print " surrounding bards %s|#|%s mark searched nodes" % (green,normal)
        print "------------------------------------------------------"
        

# These are point sets that I found useful for finding problems with my
# implementation. 
prob1 = ((4,1),(1,3))
prob2 = ((4,1),(0,7))
prob3 = ((0,7),(4,1))
prob4 = ((2,2),(11,11))
prob5 = ((5,0),(11,11))

# create the test environ... change map size here
test_prob = prob5

# 12x12
map1 = [
"ggggggggggggg",
"ggggggggggggg",
"ggggggggggggg",
"ggaaggggggggg",
"ggaaawwwggggg",
"ggaaaaaaaaaaa",
"ggaaaaawwgggw",
"ggaaaaawwwwww",
"gwwwwwwwwwwww",
"gwgwwwwgwwwww",
"wggwwwwwwwwww",
"ggggggggggggw",
"wgwwwwgwwgggw"
]
maps = [] 

from map.map import Map
for i in range(1): 
    map = Map(map1) 
    path = DbgPath(map) 
    maps.append(path)

# display's a ascii map
# key: red|yellow|green = high/medium/low terrain costs
# magenta is used to show the path
path.show_path(test_prob)
print path.path

#import time
#time.sleep(3)
# profiling: just run the path calculation method
#import profile
#def test(maps=maps):
#    while maps:
#        i = randint(0,len(maps)-1)
#        path = maps[i]
##        path.show_path()
#        path.calculatePath(*test_prob)
##        print 'path length:',len(path.calculatePath(*test_prob))
#        del maps[i]
#profile.run("test()")




